---
layout: default
title: dockerfile resource scans
nav_order: 1
---

# dockerfile resource scans (auto generated)

|    | Id             | Type       | Entity     | Policy                                                                                                                                                                                  | IaC        | Resource Link                                                                                                                                                     |
|----|----------------|------------|------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|  0 | CKV_DOCKER_1   | dockerfile | EXPOSE     | Ensure port 22 is not exposed                                                                                                                                                           | dockerfile | [ExposePort22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/ExposePort22.py)                                                    |
|  1 | CKV_DOCKER_2   | dockerfile | *          | Ensure that HEALTHCHECK instructions have been added to container images                                                                                                                | dockerfile | [HealthcheckExists.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/HealthcheckExists.py)                                          |
|  2 | CKV_DOCKER_3   | dockerfile | *          | Ensure that a user for the container has been created                                                                                                                                   | dockerfile | [UserExists.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/UserExists.py)                                                        |
|  3 | CKV_DOCKER_4   | dockerfile | ADD        | Ensure that COPY is used instead of ADD in Dockerfiles                                                                                                                                  | dockerfile | [AddExists.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/AddExists.py)                                                          |
|  4 | CKV_DOCKER_5   | dockerfile | RUN        | Ensure update instructions are not use alone in the Dockerfile                                                                                                                          | dockerfile | [UpdateNotAlone.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/UpdateNotAlone.py)                                                |
|  5 | CKV_DOCKER_6   | dockerfile | MAINTAINER | Ensure that LABEL maintainer is used instead of MAINTAINER (deprecated)                                                                                                                 | dockerfile | [MaintainerExists.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/MaintainerExists.py)                                            |
|  6 | CKV_DOCKER_7   | dockerfile | FROM       | Ensure the base image uses a non latest version tag                                                                                                                                     | dockerfile | [ReferenceLatestTag.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/ReferenceLatestTag.py)                                        |
|  7 | CKV_DOCKER_8   | dockerfile | USER       | Ensure the last USER is not root                                                                                                                                                        | dockerfile | [RootUser.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/RootUser.py)                                                            |
|  8 | CKV_DOCKER_9   | dockerfile | RUN        | Ensure that APT isn't used                                                                                                                                                              | dockerfile | [RunUsingAPT.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/RunUsingAPT.py)                                                      |
|  9 | CKV_DOCKER_10  | dockerfile | WORKDIR    | Ensure that WORKDIR values are absolute paths                                                                                                                                           | dockerfile | [WorkdirIsAbsolute.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/WorkdirIsAbsolute.py)                                          |
| 10 | CKV_DOCKER_11  | dockerfile | FROM       | Ensure From Alias are unique for multistage builds.                                                                                                                                     | dockerfile | [AliasIsUnique.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/AliasIsUnique.py)                                                  |
| 11 | CKV2_DOCKER_1  | resource   | RUN        | Ensure that sudo isn't used                                                                                                                                                             | dockerfile | [RunUsingSudo.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunUsingSudo.yaml)                                   |
| 12 | CKV2_DOCKER_2  | resource   | RUN        | Ensure that certificate validation isn't disabled with curl                                                                                                                             | dockerfile | [RunUnsafeCurl.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunUnsafeCurl.yaml)                                 |
| 13 | CKV2_DOCKER_3  | resource   | RUN        | Ensure that certificate validation isn't disabled with wget                                                                                                                             | dockerfile | [RunUnsafeWget.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunUnsafeWget.yaml)                                 |
| 14 | CKV2_DOCKER_4  | resource   | RUN        | Ensure that certificate validation isn't disabled with the pip '--trusted-host' option                                                                                                  | dockerfile | [RunPipTrustedHost.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunPipTrustedHost.yaml)                         |
| 15 | CKV2_DOCKER_5  | resource   | ARG        | Ensure that certificate validation isn't disabled with the PYTHONHTTPSVERIFY environment variable                                                                                       | dockerfile | [EnvPythonHttpsVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvPythonHttpsVerify.yaml)                   |
| 16 | CKV2_DOCKER_5  | resource   | ENV        | Ensure that certificate validation isn't disabled with the PYTHONHTTPSVERIFY environment variable                                                                                       | dockerfile | [EnvPythonHttpsVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvPythonHttpsVerify.yaml)                   |
| 17 | CKV2_DOCKER_5  | resource   | RUN        | Ensure that certificate validation isn't disabled with the PYTHONHTTPSVERIFY environment variable                                                                                       | dockerfile | [EnvPythonHttpsVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvPythonHttpsVerify.yaml)                   |
| 18 | CKV2_DOCKER_6  | resource   | ARG        | Ensure that certificate validation isn't disabled with the NODE_TLS_REJECT_UNAUTHORIZED environment variable                                                                            | dockerfile | [EnvNodeTlsRejectUnauthorized.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvNodeTlsRejectUnauthorized.yaml)   |
| 19 | CKV2_DOCKER_6  | resource   | ENV        | Ensure that certificate validation isn't disabled with the NODE_TLS_REJECT_UNAUTHORIZED environment variable                                                                            | dockerfile | [EnvNodeTlsRejectUnauthorized.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvNodeTlsRejectUnauthorized.yaml)   |
| 20 | CKV2_DOCKER_6  | resource   | RUN        | Ensure that certificate validation isn't disabled with the NODE_TLS_REJECT_UNAUTHORIZED environment variable                                                                            | dockerfile | [EnvNodeTlsRejectUnauthorized.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvNodeTlsRejectUnauthorized.yaml)   |
| 21 | CKV2_DOCKER_7  | resource   | RUN        | Ensure that packages with untrusted or missing signatures are not used by apk via the '--allow-untrusted' option                                                                        | dockerfile | [RunApkAllowUntrusted.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunApkAllowUntrusted.yaml)                   |
| 22 | CKV2_DOCKER_8  | resource   | RUN        | Ensure that packages with untrusted or missing signatures are not used by apt-get via the '--allow-unauthenticated' option                                                              | dockerfile | [RunAptGetAllowUnauthenticated.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunAptGetAllowUnauthenticated.yaml) |
| 23 | CKV2_DOCKER_9  | resource   | RUN        | Ensure that packages with untrusted or missing GPG signatures are not used by dnf, tdnf, or yum via the '--nogpgcheck' option                                                           | dockerfile | [RunYumNoGpgCheck.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunYumNoGpgCheck.yaml)                           |
| 24 | CKV2_DOCKER_10 | resource   | RUN        | Ensure that packages with untrusted or missing signatures are not used by rpm via the '--nodigest', '--nosignature', '--noverify', or '--nofiledigest' options                          | dockerfile | [RunRpmNoSignature.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunRpmNoSignature.yaml)                         |
| 25 | CKV2_DOCKER_11 | resource   | RUN        | Ensure that the '--force-yes' option is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | dockerfile | [RunAptGetForceYes.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunAptGetForceYes.yaml)                         |
| 26 | CKV2_DOCKER_12 | resource   | ARG        | Ensure that certificate validation isn't disabled for npm via the 'NPM_CONFIG_STRICT_SSL' environment variable                                                                          | dockerfile | [EnvNpmConfigStrictSsl.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvNpmConfigStrictSsl.yaml)                 |
| 27 | CKV2_DOCKER_12 | resource   | ENV        | Ensure that certificate validation isn't disabled for npm via the 'NPM_CONFIG_STRICT_SSL' environment variable                                                                          | dockerfile | [EnvNpmConfigStrictSsl.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvNpmConfigStrictSsl.yaml)                 |
| 28 | CKV2_DOCKER_12 | resource   | RUN        | Ensure that certificate validation isn't disabled for npm via the 'NPM_CONFIG_STRICT_SSL' environment variable                                                                          | dockerfile | [EnvNpmConfigStrictSsl.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvNpmConfigStrictSsl.yaml)                 |
| 29 | CKV2_DOCKER_13 | resource   | RUN        | Ensure that certificate validation isn't disabled for npm or yarn by setting the option strict-ssl to false                                                                             | dockerfile | [RunNpmConfigSetStrictSsl.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunNpmConfigSetStrictSsl.yaml)           |
| 30 | CKV2_DOCKER_14 | resource   | ARG        | Ensure that certificate validation isn't disabled for git by setting the environment variable 'GIT_SSL_NO_VERIFY' to any value                                                          | dockerfile | [EnvGitSslNoVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvGitSslNoVerify.yaml)                         |
| 31 | CKV2_DOCKER_14 | resource   | ENV        | Ensure that certificate validation isn't disabled for git by setting the environment variable 'GIT_SSL_NO_VERIFY' to any value                                                          | dockerfile | [EnvGitSslNoVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvGitSslNoVerify.yaml)                         |
| 32 | CKV2_DOCKER_14 | resource   | RUN        | Ensure that certificate validation isn't disabled for git by setting the environment variable 'GIT_SSL_NO_VERIFY' to any value                                                          | dockerfile | [EnvGitSslNoVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvGitSslNoVerify.yaml)                         |
| 33 | CKV2_DOCKER_15 | resource   | RUN        | Ensure that the yum and dnf package managers are not configured to disable SSL certificate validation via the 'sslverify' configuration option                                          | dockerfile | [RunYumConfigManagerSslVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunYumConfigManagerSslVerify.yaml)   |
| 34 | CKV2_DOCKER_16 | resource   | ARG        | Ensure that certificate validation isn't disabled with pip via the 'PIP_TRUSTED_HOST' environment variable                                                                              | dockerfile | [EnvPipTrustedHost.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvPipTrustedHost.yaml)                         |
| 35 | CKV2_DOCKER_16 | resource   | ENV        | Ensure that certificate validation isn't disabled with pip via the 'PIP_TRUSTED_HOST' environment variable                                                                              | dockerfile | [EnvPipTrustedHost.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvPipTrustedHost.yaml)                         |
| 36 | CKV2_DOCKER_16 | resource   | RUN        | Ensure that certificate validation isn't disabled with pip via the 'PIP_TRUSTED_HOST' environment variable                                                                              | dockerfile | [EnvPipTrustedHost.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/EnvPipTrustedHost.yaml)                         |
| 37 | CKV2_DOCKER_17 | resource   | RUN        | Ensure that 'chpasswd' is not used to set or remove passwords                                                                                                                           | dockerfile | [RunChpasswd.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/dockerfile/checks/graph_checks/RunChpasswd.yaml)                                     |


---


